/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media;

import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.container.InvisibleSlot;
import dan200.computercraft.shared.media.items.PrintoutData;
import java.util.function.Predicate;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PrintoutMenu
extends AbstractContainerMenu {
    public static final int DATA_CURRENT_PAGE = 0;
    private static final int DATA_SIZE = 1;
    public static final int PAGE_BUTTON_OFFSET = 100;
    private final Predicate<Player> valid;
    private final ContainerData currentPage;

    public PrintoutMenu(int containerId, Container container, int slotIdx, Predicate<Player> valid, ContainerData currentPage) {
        super((MenuType)ModRegistry.Menus.PRINTOUT.get(), containerId);
        this.valid = valid;
        this.currentPage = currentPage;
        this.addSlot(new InvisibleSlot(container, slotIdx){

            public void setChanged() {
                super.setChanged();
                PrintoutMenu.this.slotsChanged(this.container);
            }
        });
        this.addDataSlots(currentPage);
    }

    public static PrintoutMenu createRemote(int containerId) {
        return new PrintoutMenu(containerId, (Container)new SimpleContainer(1), 0, p -> true, (ContainerData)new SimpleContainerData(1));
    }

    public static PrintoutMenu createInHand(int containerId, Player player, InteractionHand hand) {
        ItemStack currentStack = player.getItemInHand(hand);
        Item currentItem = currentStack.getItem();
        int slot = switch (hand) {
            default -> throw new MatchException(null, null);
            case InteractionHand.MAIN_HAND -> player.getInventory().selected;
            case InteractionHand.OFF_HAND -> 40;
        };
        return new PrintoutMenu(containerId, (Container)player.getInventory(), slot, p -> player.getItemInHand(hand).getItem() == currentItem, (ContainerData)new SimpleContainerData(1));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.valid.test(player);
    }

    public boolean clickMenuButton(Player player, int id) {
        if (id >= 100) {
            int page = Mth.clamp((int)(id - 100), (int)0, (int)(PrintoutData.getOrEmpty((DataComponentHolder)this.getPrintout()).pages() - 1));
            this.setData(0, page);
            return true;
        }
        return super.clickMenuButton(player, id);
    }

    public ItemStack getPrintout() {
        return this.getSlot(0).getItem();
    }

    public int getPage() {
        return this.currentPage.get(0);
    }

    public void setData(int id, int data) {
        super.setData(id, data);
        this.broadcastChanges();
    }
}

